/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.CepInstanceEvent;
import com.cisco.pt.ipc.events.CepInstanceEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.system.CepInstance;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CepInstanceEventRegistry
extends IPCEventRegistry {
    protected Set<CepInstanceEventListener> globalListeners = new HashSet<CepInstanceEventListener>();
    protected Map<String, Set<CepInstanceEventListener>> specificObjectListeners = new HashMap<String, Set<CepInstanceEventListener>>();
    private static Log logger = LogFactory.getLog(CepInstanceEventRegistry.class);

    public CepInstanceEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "CepInstance";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        CepInstanceEvent evt = null;
        if (eventName.equalsIgnoreCase("messageReceived")) {
            evt = new CepInstanceEvent.MessageReceived(event);
        } else if (eventName.equalsIgnoreCase("remoteMessageReceived")) {
            evt = new CepInstanceEvent.RemoteMessageReceived(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (CepInstanceEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<CepInstanceEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (CepInstanceEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(CepInstanceEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("messageReceived");
                this.register("remoteMessageReceived");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(CepInstanceEventListener listener, CepInstance objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<CepInstanceEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<CepInstanceEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "messageReceived");
                this.register(uuid, "remoteMessageReceived");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(CepInstanceEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("messageReceived");
                this.deregister("remoteMessageReceived");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(CepInstanceEventListener listener, CepInstance objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<CepInstanceEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "messageReceived");
            this.deregister(uuid, "remoteMessageReceived");
            specificListeners.remove(listener);
        }
    }

    public void addListener(CepInstanceEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(CepInstanceEventListener listener, CepInstance objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(CepInstanceEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(CepInstanceEventListener listener, CepInstance objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

